using System;
using System.Data;
using gov.va.med.vbecs.ExceptionManagement;
using gov.va.med.vbecs.Common;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>03/11/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// ReferenceData data access layer class.
	///</summary>

	#endregion
	
	public class ReferenceData
    {
        private static DataSet _referenceDataSet;

        /// <summary>
        /// Not an object. Only static methods.
        /// </summary>
        private ReferenceData()
        {
        }

        /// <summary>
        /// Merges Result Data :)
        /// </summary>
        /// <param name="ds"></param>
        static private void MergeResultData(DataSet ds)
        {
            lock(typeof(ReferenceData)) 
            {
                if (_referenceDataSet == null) 
                {
                    _referenceDataSet = ds;
                }
                else 
                {
                    _referenceDataSet.Merge(ds);
                }
            }
        }
        
        static private DataSet GetDataSet(string procName)
        {
            DataSet ds;
            try
            {
                ds = Common.StoredProcedure.GetData(procName);
            }
            catch (Exception ex)
            {
                ExceptionManager.Publish(ex);
                throw ex;
            }
            return ds;
        }


        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1413"> 
		///		<ExpectedInput>UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>DataRow of UnitStatus information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1420"> 
		///		<ExpectedInput>Invalid UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>        
		/// <summary>
        /// Get a single row of UnitStatus data, based on UnitStatusCode.  
        /// </summary>
        /// <returns>DataRow of UnitStatus</returns>
        public static DataRow GetUnitStatus(string unitStatusCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.UnitStatus.TableName)))
            {
                GetUnitStatusList();
            }

            DataRow[] dr = _referenceDataSet.Tables[TABLE.UnitStatus.TableName].Select(String.Format(TABLE.UnitStatus.UnitStatusCode+" = '{0}'", unitStatusCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.UnitStatus.TableName+" item {0} not found.",unitStatusCode));
            }

            return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1423"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of UnitStatus information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1424"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of UnitStatus data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all UnitStatus rows</returns>
        public static DataTable GetUnitStatusList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.UnitStatus.TableName))
			{
				return _referenceDataSet.Tables[TABLE.UnitStatus.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetUnitStatusList.StoredProcName);
			ds.Tables[0].TableName = TABLE.UnitStatus.TableName;
            
			MergeResultData(ds);

			return _referenceDataSet.Tables[TABLE.UnitStatus.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1425"> 
		///		<ExpectedInput>AntibodyScreenDisplay code</ExpectedInput>
		///		<ExpectedOutput>DataRow of AntibodyScreenDisplay information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1426"> 
		///		<ExpectedInput>Invalid AntibodyScreenDisplay code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of AntibodyScreenDisplay data, based on AntibodyScreenDisplayCode.  
        /// </summary>
        /// <returns>DataRow of AntibodyScreenDisplay</returns>
        public static DataRow GetAntibodyScreenDisplay(int antibodyScreenDisplayCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.AntibodyScreenDisplay.TableName)))
            {
                GetAntibodyScreenDisplayList();
            }

            DataRow[] dr = _referenceDataSet.Tables[TABLE.AntibodyScreenDisplay.TableName].Select(String.Format(TABLE.AntibodyScreenDisplay.AntibodyScreenDisplayCode+" = {0}", antibodyScreenDisplayCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.AntibodyScreenDisplay.TableName+" item {0} not found.",antibodyScreenDisplayCode));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1428"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of AntibodyScreenDisplay information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1429"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of AntibodyScreenDisplay data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all AntibodyScreenDisplay rows</returns>
        public static DataTable GetAntibodyScreenDisplayList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.AntibodyScreenDisplay.TableName))
			{
				return _referenceDataSet.Tables[TABLE.AntibodyScreenDisplay.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetAntibodyScreenDisplayList.StoredProcName);
            ds.Tables[0].TableName = TABLE.AntibodyScreenDisplay.TableName;

			MergeResultData(ds);

            return _referenceDataSet.Tables[TABLE.AntibodyScreenDisplay.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1433"> 
		///		<ExpectedInput>BloodType Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of BloodType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1434"> 
		///		<ExpectedInput>Invalid BloodType Code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of BloodType data, based on BloodTypeCode.  
        /// </summary>
        /// <returns>DataRow of BloodType</returns>
        public static DataRow GetBloodType(string bloodTypeCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.BloodType.TableName)))
            {
                GetBloodTypeList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.BloodType.TableName].Select(String.Format(TABLE.BloodType.BloodTypeCode+" = '{0}'", bloodTypeCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.BloodType.TableName+" item {0} not found.",bloodTypeCode));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1435"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of BloodType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1436"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of BloodType data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all BloodType rows</returns>
        public static DataTable GetBloodTypeList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.BloodType.TableName))
			{
				return _referenceDataSet.Tables[TABLE.BloodType.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetBloodTypeList.StoredProcName);
            ds.Tables[0].TableName = TABLE.BloodType.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.BloodType.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1438"> 
		///		<ExpectedInput>TransfusionRequirementCategory Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of TransfusionRequirementCategory information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1439"> 
		///		<ExpectedInput>Invalid TransfusionRequirementCategory Code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of TransfusionRequirementCategory data, based on TransfusionRequirementCategoryCode.  
        /// </summary>
        /// <returns>DataRow of TransfusionRequirementCategory</returns>
        public static DataRow GetTransfusionRequirementCategory(string transfusionRequirementCategoryCode)
        {
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TransfusionRequirementCategory.TableName)))
			{
				GetTransfusionRequirementCategoryList();
			}

			DataRow[] dr = _referenceDataSet.Tables[TABLE.TransfusionRequirementCategory.TableName].Select(String.Format(TABLE.TransfusionRequirementCategory.TransfusionRequirementCategoryCode+" = '{0}'", transfusionRequirementCategoryCode));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.TransfusionRequirementCategory.TableName+" item {0} not found.",transfusionRequirementCategoryCode));
			}

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1440"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TransfusionRequirementCategory information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1441"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of TransfusionRequirementCategory data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all TransfusionRequirementCategory rows</returns>
        public static DataTable GetTransfusionRequirementCategoryList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TransfusionRequirementCategory.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TransfusionRequirementCategory.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetTransfusionRequirementCategoryList.StoredProcName);
            ds.Tables[0].TableName = TABLE.TransfusionRequirementCategory.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.TransfusionRequirementCategory.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1442"> 
		///		<ExpectedInput>UnitStatusCode</ExpectedInput>
		///		<ExpectedOutput>DataTable of AntibodyType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1443"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of AntibodyType data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all AntibodyType rows</returns>
        public static DataTable GetAntibodyTypeList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.AntibodyType.TableName))
			{
				return _referenceDataSet.Tables[TABLE.AntibodyType.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetAntibodyTypeList.StoredProcName);
            ds.Tables[0].TableName = TABLE.AntibodyType.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.AntibodyType.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1445"> 
		///		<ExpectedInput>AntigenType Id</ExpectedInput>
		///		<ExpectedOutput>DataRow of AntigenType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1446"> 
		///		<ExpectedInput>Invalid AntigenType Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get a single row of AntigenType data, based on AntigenTypeId.  
		/// </summary>
		/// <returns>DataRow of AntigenType</returns>
		public static DataRow GetAntigenType(int antigenTypeId)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.AntigenType.TableName)))
			{
				GetAntigenTypeList();
			}
				
			DataRow[] dr = _referenceDataSet.Tables[TABLE.AntigenType.TableName].Select(String.Format(TABLE.AntigenType.AntigenTypeId+" = {0}", antigenTypeId));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.AntigenType.TableName+" item {0} not found.",antigenTypeId));
			}
			
			return dr[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1448"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of AntigenType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1449"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get all rows of AntigenType data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all AntibodyType rows</returns>
		public static DataTable GetAntigenTypeList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.AntigenType.TableName))
			{
				return _referenceDataSet.Tables[TABLE.AntigenType.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetAntigenTypeList.StoredProcName);
			ds.Tables[0].TableName = TABLE.AntigenType.TableName;
			
			MergeResultData(ds);
			
			return _referenceDataSet.Tables[TABLE.AntigenType.TableName];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1450"> 
		///		<ExpectedInput>ComponentClass Id</ExpectedInput>
		///		<ExpectedOutput>DataRow of ComponentClass information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1451"> 
		///		<ExpectedInput>Invalid ComponentClass Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of ComponentClass data, based on ComponentClassId.  
        /// </summary>
        /// <returns>DataRow of ComponentClass</returns>
        public static DataRow GetComponentClass(int componentClassId)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ComponentClass.TableName)))
            {
                GetComponentClassList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.ComponentClass.TableName].Select(String.Format(TABLE.ComponentClass.ComponentClassId+" = {0}", componentClassId));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.ComponentClass.TableName+" item {0} not found.",componentClassId));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1454"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of ComponentClass Information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1455"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of ComponentClass data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all ComponentClass rows</returns>
        public static DataTable GetComponentClassList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ComponentClass.TableName))
			{
				return _referenceDataSet.Tables[TABLE.ComponentClass.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetComponentClassList.StoredProcName);
            ds.Tables[0].TableName = TABLE.ComponentClass.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.ComponentClass.TableName];
        }



		///<Developers>
		///	<Developer>Greg Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8067"> 
		///		<ExpectedInput>LockFunctionId</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8068"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of VbecsLockFunction data, based on LockFunctionId.  
		/// </summary>
		/// <returns>DataRow of ProductModification</returns>
		public static DataRow GetLockFunction(Common.LockFunctions lockFunctionId)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.VbecsLockFunction.TableName)))
			{
				GetLockFunctionList();
			}

			DataRow[] dr = _referenceDataSet.Tables[TABLE.VbecsLockFunction.TableName].Select(String.Format(TABLE.VbecsLockFunction.VbecsFunctionId + " = '{0}'", ((int)lockFunctionId).ToString()));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.VbecsLockFunction.TableName+" item {0} not found.",((int)lockFunctionId)).ToString());
			}

			return dr[0];
		}


		///<Developers>
		///	<Developer>Greg Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8069"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8070"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of VbecsLockFunction data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all VbecsLockFunction rows</returns>
		public static DataTable GetLockFunctionList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.VbecsLockFunction.TableName))
			{
				return _referenceDataSet.Tables[TABLE.VbecsLockFunction.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetLockFunctionList.StoredProcName);
			ds.Tables[0].TableName = TABLE.VbecsLockFunction.TableName;
			
			MergeResultData(ds);
			
			return _referenceDataSet.Tables[TABLE.VbecsLockFunction.TableName];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7281"> 
		///		<ExpectedInput>TaskStatus Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of v information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7282"> 
		///		<ExpectedInput>Invalid TaskStatus</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get a single row of TaskStatus data, based on TaskStatusCode.  
		/// </summary>
		/// <returns>DataRow of TaskStatus</returns>
		public static DataRow GetTaskStatus(string taskStatusCode)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TaskStatus.TableName)))
			{
				GetTaskStatusList();
			}

			DataRow[] dr = _referenceDataSet.Tables[TABLE.TaskStatus.TableName].Select(String.Format(TABLE.TaskStatus.TaskStatusCode+" = '{0}'", taskStatusCode));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.TaskStatus.TableName+" item {0} not found.",taskStatusCode));
			}

			return dr[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7283"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TaskStatus information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7284"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get all rows of TaskStatus data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all TaskStatus rows</returns>
		public static DataTable GetTaskStatusList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TaskStatus.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TaskStatus.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetTaskStatusList.StoredProcName);
			ds.Tables[0].TableName = TABLE.TaskStatus.TableName;
			
			MergeResultData(ds);
			
			return _referenceDataSet.Tables[TABLE.TaskStatus.TableName];
		}


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7285"> 
		///		<ExpectedInput>SpecimenStatus Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of v information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7286"> 
		///		<ExpectedInput>Invalid SpecimenStatus</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get a single row of SpecimenStatus data, based on SpecimenStatusCode.  
		/// </summary>
		/// <returns>DataRow of SpecimenStatus</returns>
		public static DataRow GetSpecimenStatus(string specimenStatusCode)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.SpecimenStatus.TableName)))
			{
				GetSpecimenStatusList();
			}

			DataRow[] dr = _referenceDataSet.Tables[TABLE.SpecimenStatus.TableName].Select(String.Format(TABLE.SpecimenStatus.SpecimenStatusCode+" = '{0}'", specimenStatusCode));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.SpecimenStatus.TableName+" item {0} not found.",specimenStatusCode));
			}

			return dr[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7287"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of SpecimenStatus information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7288"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get all rows of SpecimenStatus data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all SpecimenStatus rows</returns>
		public static DataTable GetSpecimenStatusList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.SpecimenStatus.TableName))
			{
				return _referenceDataSet.Tables[TABLE.SpecimenStatus.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetSpecimenStatusList.StoredProcName);
			ds.Tables[0].TableName = TABLE.SpecimenStatus.TableName;
			
			MergeResultData(ds);
			
			return _referenceDataSet.Tables[TABLE.SpecimenStatus.TableName];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1456"> 
		///		<ExpectedInput>ProductModification Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of ProductModification information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1457"> 
		///		<ExpectedInput>Invalid ProductModificationCode</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get a single row of ProductModification data, based on ProductModificationCode.  
		/// </summary>
		/// <returns>DataRow of ProductModification</returns>
		public static DataRow GetProductModification(string productModificationCode)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ProductModification.TableName)))
			{
				GetProductModificationList();
			}

			DataRow[] dr = _referenceDataSet.Tables[TABLE.ProductModification.TableName].Select(String.Format(TABLE.ProductModification.ProductModificationCode+" = '{0}'", productModificationCode));
			
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.ProductModification.TableName+" item {0} not found.",productModificationCode));
			}

			return dr[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1459"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of ProductModification information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1460"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
		/// <summary>
		/// Get all rows of ProductModification data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all ProductModification rows</returns>
		public static DataTable GetProductModificationList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ProductModification.TableName))
			{
				return _referenceDataSet.Tables[TABLE.ProductModification.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetProductModificationList.StoredProcName);
			ds.Tables[0].TableName = TABLE.ProductModification.TableName;
			
			MergeResultData(ds);
			
			return _referenceDataSet.Tables[TABLE.ProductModification.TableName];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1461"> 
		///		<ExpectedInput>State Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of State information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1462"> 
		///		<ExpectedInput>Invalid StateCode</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of State data, based on StateCode.  
        /// </summary>
        /// <returns>DataRow of State</returns>
        public static DataRow GetState(string stateCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.State.TableName)))
            {
                GetStateList();
            }

            DataRow[] dr = _referenceDataSet.Tables[TABLE.State.TableName].Select(String.Format(TABLE.State.StateCode+" = '{0}'", stateCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.State.TableName+" item {0} not found.",stateCode));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1465"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of State information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1466"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of State data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all State rows</returns>
        public static DataTable GetStateList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.State.TableName))
			{
				return _referenceDataSet.Tables[TABLE.State.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetStateList.StoredProcName);
            ds.Tables[0].TableName = TABLE.State.TableName;

			MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.State.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1467"> 
		///		<ExpectedInput>TestingMethod Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of TestingMethod information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1468"> 
		///		<ExpectedInput>Invalid TestingMethod Code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of TestingMethod data, based on TestingMethodCode.  
        /// </summary>
        /// <returns>DataRow of TestingMethod</returns>
        public static DataRow GetTestingMethod(string testingMethodCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TestingMethod.TableName)))
            {
                GetTestingMethodList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.TestingMethod.TableName].Select(String.Format(TABLE.TestingMethod.TestingMethodCode+" = '{0}'", testingMethodCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.TestingMethod.TableName+" item {0} not found.",testingMethodCode));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1469"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TestingMethod information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1470"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of TestingMethod data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all TestingMethod rows</returns>
        public static DataTable GetTestingMethodList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TestingMethod.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TestingMethod.TableName];
			}


            DataSet ds = GetDataSet(STOREDPROC.GetTestingMethodList.StoredProcName);
            ds.Tables[0].TableName = TABLE.TestingMethod.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.TestingMethod.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1479"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TestResult information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1480"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of TestResult data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all TestResult rows</returns>
        public static DataTable GetTestResultList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TestResult.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TestResult.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetTestResultList.StoredProcName);
            ds.Tables[0].TableName = TABLE.TestResult.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.TestResult.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1483"> 
		///		<ExpectedInput>TransfusionReactionType Code</ExpectedInput>
		///		<ExpectedOutput>DataRow of TransfusionReactionType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1484"> 
		///		<ExpectedInput>Invalid TransfusionReactionType Code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of TransfusionReactionType data, based on TransfusionReactionTypeCode.  
        /// </summary>
        /// <returns>DataRow of TransfusionReactionType</returns>
        public static DataRow GetTransfusionReactionType(char transfusionReactionTypeCode)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TransfusionReactionType.TableName)))
            {
                GetTransfusionReactionTypeList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.TransfusionReactionType.TableName].Select(String.Format(TABLE.TransfusionReactionType.TransfusionReactionTypeCode+" = '{0}'", transfusionReactionTypeCode));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.TransfusionReactionType.TableName+" item {0} not found.",transfusionReactionTypeCode));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1485"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TransfustionReactionType information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1486"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of TransfusionReactionType data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all TransfusionReactionType rows</returns>
        public static DataTable GetTransfusionReactionTypeList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TransfusionReactionType.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TransfusionReactionType.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetTransfusionReactionTypeList.StoredProcName);
            ds.Tables[0].TableName = TABLE.TransfusionReactionType.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.TransfusionReactionType.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1487"> 
		///		<ExpectedInput>UserRole Id</ExpectedInput>
		///		<ExpectedOutput>DataRow of UserRole information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1488"> 
		///		<ExpectedInput>Invalid UserRole Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of UserRole data, based on UserRoleId.  
        /// </summary>
        /// <returns>DataRow of UserRole</returns>
        public static DataRow GetUserRole(int userRoleID)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.UserRole.TableName)))
            {
                GetUserRoleList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.UserRole.TableName].Select(String.Format(TABLE.UserRole.UserRoleId+" = {0}", userRoleID));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.UserRole.TableName+" item {0} not found.",userRoleID));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1491"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of UserRole information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1492"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of UserRole data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all UserRole rows</returns>
        public static DataTable GetUserRoleList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.UserRole.TableName))
			{
				return _referenceDataSet.Tables[TABLE.UserRole.TableName];
			}

            DataSet ds = GetDataSet(STOREDPROC.GetUserRoleList.StoredProcName);
            ds.Tables[0].TableName = TABLE.UserRole.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.UserRole.TableName];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1493"> 
		///		<ExpectedInput>TimeZone Id</ExpectedInput>
		///		<ExpectedOutput>DataRow of TimeZone information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1494"> 
		///		<ExpectedInput>Invalid TimeZone Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get a single row of TimeZone data, based on TimeZoneId.  
        /// </summary>
        /// <returns>DataRow of TimeZone</returns>
        public static DataRow GetTimeZone(string timeZoneID)
        {
            if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TimeZone.TableName)))
            {
                GetTimeZoneList();
            }
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.TimeZone.TableName].Select(String.Format(TABLE.TimeZone.TimeZoneId+" = '{0}'", timeZoneID));
            
			if (dr.Length != 1)
            {
                throw new DataAccessLayerException(String.Format(TABLE.TimeZone.TableName+" item {0} not found.",timeZoneID));
            }

			return dr[0];
        }

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1495"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of TimeZone information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1496"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces> 
        /// <summary>
        /// Get all rows of TimeZone data into a static DataSet, loaded on first use. 
        /// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
        /// </summary>
        /// <returns>DataTable of all TimeZone rows</returns>
        public static DataTable GetTimeZoneList()
        {
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.TimeZone.TableName))
			{
				return _referenceDataSet.Tables[TABLE.TimeZone.TableName];
			}

			DataSet ds = GetDataSet(Common.VbecsStoredProcs.GetTimeZoneList.StoredProcName);
            ds.Tables[0].TableName = TABLE.TimeZone.TableName;
            
            MergeResultData(ds);
            
            return _referenceDataSet.Tables[TABLE.TimeZone.TableName];
        }


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8071"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8072"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of OrderableTest data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all OrderableTest rows</returns>
		public static DataTable GetOrderableTestList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.OrderableTest.TableName))
			{
				return _referenceDataSet.Tables[TABLE.OrderableTest.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetOrderableTestList.StoredProcName);
			ds.Tables[0].TableName = TABLE.OrderableTest.TableName;
            
			MergeResultData(ds);
            
			return _referenceDataSet.Tables[TABLE.OrderableTest.TableName];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8073"> 
		///		<ExpectedInput>Valid Id</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8074"> 
		///		<ExpectedInput>Invalid Id</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of OrderableTest data, based on OrderableTestId.  
		/// </summary>
		/// <param name="orderableTestId">OrderableTestId</param>
		/// <returns>DataRow of OrderableTest</returns>
		public static DataRow GetOrderableTest(int orderableTestId)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.OrderableTest.TableName)))
			{
				GetOrderableTestList();
			}
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.OrderableTest.TableName].Select(String.Format(TABLE.OrderableTest.OrderableTestId+" = '{0}'", orderableTestId));
            
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.OrderableTest.TableName+" item {0} not found.",orderableTestId));
			}

			return dr[0];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8075"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8076"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of ReactivityPhase data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all ReactivityPhase rows</returns>
		public static DataTable GetReactivityPhaseList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ReactivityPhase.TableName))
			{
				return _referenceDataSet.Tables[TABLE.ReactivityPhase.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetReactivityPhaseList.StoredProcName);
			ds.Tables[0].TableName = TABLE.ReactivityPhase.TableName;
            
			MergeResultData(ds);
            
			return _referenceDataSet.Tables[TABLE.ReactivityPhase.TableName];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8077"> 
		///		<ExpectedInput>Valid code</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8078"> 
		///		<ExpectedInput>Invalid code</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of ReactivityPhase data, based on ReactivityPhaseCode.  
		/// </summary>
		/// <param name="reactivityPhaseCode">ReactivityPhaseCode</param>
		/// <returns>DataRow of ReactivityPhase</returns>
		public static DataRow GetReactivityPhase(int reactivityPhaseCode)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ReactivityPhase.TableName)))
			{
				GetReactivityPhaseList();
			}
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.ReactivityPhase.TableName].Select(String.Format(TABLE.ReactivityPhase.ReactivityPhaseCode+" = '{0}'", reactivityPhaseCode));
            
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.ReactivityPhase.TableName+" item {0} not found.",reactivityPhaseCode));
			}

			return dr[0];
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8079"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8080"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all rows of ProductType data into a static DataSet, loaded on first use. 
		/// Returns a DataTable with the selected data. Use the "Select" DataTable method to filter subsets.
		/// </summary>
		/// <returns>DataTable of all ProductType rows</returns>
		public static DataTable GetProductTypeList()
		{
			if (_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ProductType.TableName))
			{
				return _referenceDataSet.Tables[TABLE.ProductType.TableName];
			}

			DataSet ds = GetDataSet(STOREDPROC.GetProductTypeLookupList.StoredProcName);
			ds.Tables[0].TableName = TABLE.ProductType.TableName;
            
			MergeResultData(ds);
            
			return _referenceDataSet.Tables[TABLE.ProductType.TableName];
		}



		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8081"> 
		///		<ExpectedInput>Valid producttypecode</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8082"> 
		///		<ExpectedInput>Invalid ProductTypeCode</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a single row of ProductType data, based on ProductTypeCode.  
		/// </summary>
		/// <param name="productTypeCode">ProductTypeCode</param>
		/// <returns>DataRow of ProductType</returns>
		public static DataRow GetProductType(string productTypeCode)
		{
			if (!(_referenceDataSet != null && _referenceDataSet.Tables.Contains(TABLE.ProductType.TableName)))
			{
				GetProductTypeList();
			}
            
			DataRow[] dr = _referenceDataSet.Tables[TABLE.ProductType.TableName].Select(String.Format(TABLE.ProductType.ProductTypeCode+" = '{0}'", productTypeCode));
            
			if (dr.Length != 1)
			{
				throw new DataAccessLayerException(String.Format(TABLE.ProductType.TableName+" item {0} not found.",productTypeCode));
			}

			return dr[0];
		}
    }
}
